//$$$$$ Mouse Control (mc.c) by Gracjan Wilczewski $$$$$// 

/***********************************************************/
/* This is a simple program demonstrating how to use mouse */
/*      and sound routines from the Allegro library.       */
/***********************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"
#include "mc.h"


int
main (int argc, char *argv[])
{
  DATAFILE *datafile;
  char buf[80];

  allegro_init ();
  install_keyboard ();
  install_mouse ();
  install_timer ();

  /* load datafile */
  strcpy (buf, argv[0]);
  strcpy (get_filename (buf), "mc.dat");
  datafile = load_datafile (buf);
  if (!datafile)
    {
      allegro_exit ();
      printf ("Error loading mc.dat!\n\n");
      exit (1);
    }


  /* create screen */
  set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);
  set_pallete (datafile[PALETA_PAL].dat);

  /* install a digital sound driver */
  if (install_sound (DIGI_AUTODETECT, MIDI_NONE, argv[0]) != 0)
    {
      printf ("Error initialising sound system\n%s\n", allegro_error);
      exit (1);
    }


  /* select the custom cursor  */
  set_mouse_sprite (datafile[KURSOR_BMP].dat);


  /* and lets go */
  blit (datafile[MC_BMP].dat, screen, 0, 0, 0, 0, 640, 480);
  show_mouse (screen);

  do
    {
      if (mouse_b & 1)		// when left mouse button pressed

	{
	  play_sample (datafile[LEFT_WAV].dat, 255, 128, 1000, TRUE);
	  rest (385);
	  stop_sample (datafile[LEFT_WAV].dat);
	  textout (screen, font, "CLICK!", mouse_x, mouse_y - 10, 1);
	}


      if (mouse_b & 2)		// when right mouse button pressed

	{
	  play_sample (datafile[RIGHT_WAV].dat, 255, 128, 1000, TRUE);
	  rest (385);
	  stop_sample (datafile[RIGHT_WAV].dat);
	  textout (screen, font, "UPS!", mouse_x + 50, mouse_y - 10, 2);
	}

    }
  while (!keypressed ());


  /* unload the datafile when we are finished with it */
  unload_datafile (datafile);

  allegro_exit ();
  return 0;
}
